package ru.yandex.direct.model.generator.uf;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Нахождение непересекающихся множеств (задача DSU).
 *
 * @param <E> тип элементов множеств.
 * @see <a href="https://en.wikipedia.org/wiki/Disjoint-set_data_structure">Краткое описание задачи и структуры данных @ en.wikipedia.org</a>
 * @see <a href="https://habrahabr.ru/post/104772/">Подробное описание @ habrahabr.ru</a>
 * @see <a href="http://freecomputerbooks.com/Algorithms-4th-Edition-by-Robert-Sedgewick-and-Kevin-Wayne.html">Исчерпывающее описание, книга Algorithms 4th Edition by Robert Sedgewick and Kevin Wayne</a>
 * @see <a href="https://github.com/kartikkukreja/blog-codes/blob/master/src/Union%20Find%20(Disjoint%20Set)%20Data%20Structure.cpp">Пример реализации на C++</a>
 */
@SuppressWarnings("unused")
@ParametersAreNonnullByDefault
public interface UnionFind<E> {

    /**
     * Объединить множества, которым принадлежат элементы.
     * <p>
     * Если элементы уже принадлежат одному множеству, вызов метода безопасен,
     * т.е. составы множеств останутся неизменными и на результат этот вызов не повлияет.
     * Тем не менее возможно изменение состояния (внутреннего представления компонент) – зависит от реализации.
     */
    void connect(E p, E q);

    /**
     * @return {@code true}, если элементы принадлежат одному множеству.
     */
    boolean connected(E p, E q);

    /**
     * @param p элемент
     * @return Идентификатор множества, которому принадлежит элемент.
     */
    int find(E p);

    /**
     * @return Количество непересекающихся множеств.
     */
    int count();

}
