package ru.yandex.direct.model.generator.uf;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Оптимизация {@link WeightedQuickUnion} сжатием пути до корня.
 * <p>
 * Каждый раз при проходе до корня ноды вдоль пути
 * переподвешиваются на деда, т.е. через один элемент вверх по ветви.
 * Таким образом минимизируется средняя глубина дерева,
 * и на практике максимальная глубина не превышает 5-ти
 * даже при огромных размерах леса.
 * <p>
 * Операции {@link #connect} и {@link #find}
 * выполняются за O(1) амортизированно.
 */
@ParametersAreNonnullByDefault
class WeightedQuickUnionWithPathCompression<E> extends WeightedQuickUnion<E> {

    WeightedQuickUnionWithPathCompression(Collection<E> items) {
        super(items);
    }

    @Override
    @SuppressWarnings("squid:S1226")
    E root(E p) {
        while (!isRoot(p)) {
            index.put(p, index.get(grandparent(p)));
            p = parent(p);
        }
        return p;
    }

    private E grandparent(E p) {
        return parent(parent(p));
    }

}
