package ru.yandex.direct.model

import com.google.common.base.Preconditions.checkArgument
import java.util.Optional
import kotlin.reflect.KProperty1

class KtModelChanges<Identifier: Any, DataClass> (val id: Identifier) {
    private var changedProps: MutableMap<KProperty1<DataClass, Any?>, Any?> = mutableMapOf()

    fun <V> process(prop: KProperty1<DataClass, V>, value: V) {
        checkArgument(value != null || prop.returnType.isMarkedNullable,
            "property " + prop.name + " is marked non nullable ")
        changedProps[prop] = value
    }

    fun <V> processOptional(prop: KProperty1<DataClass, V>, valueOptional: Optional<V>?) {
        if (valueOptional == null) {
            return
        }
        process(prop, valueOptional.orElse(null))
    }

    @Suppress("UNCHECKED_CAST")
    fun <V> getVal(prop: KProperty1<DataClass, V>): V {
        return changedProps.get(prop) as V
    }

    fun <V> isPresent(prop: KProperty1<DataClass, V>): Boolean {
        return changedProps.containsKey(prop)
    }

    fun getChangedProps(): Map<KProperty1<DataClass, Any?>, Any?> = changedProps.toMap()
}
