package ru.yandex.direct.model

/**
 * Возвращает "новое" значение проперти.
 * Это значение из ModelChanges, если пропертя поменялась, а иначе из модели.
 */
fun <T : ModelWithId?, U> getPropertyValue(
    mc: ModelChanges<T>,
    model: T,
    modelProperty: ModelProperty<in T, U>
): U? {
    return if (mc.isPropChanged(modelProperty)) {
        mc.getChangedProp(modelProperty)
    } else {
        modelProperty[model]
    }
}
