package ru.yandex.direct.multitype.entity;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.jooq.JoinType;
import org.jooq.Record;
import org.jooq.SelectQuery;

@ParametersAreNonnullByDefault
public class JoinCollector {
    private final List<JoinQuery> joinQueries = new ArrayList<>();


    public void collect(JoinQuery joinQuery) {
        joinQueries.add(joinQuery);
    }

    /**
     * Добавляет к базовому SelectQuery сколлекционированные джойны.
     * Причем дедуплицирует джойны на одни и те же алиасы таблиц.
     *
     * @param baseQuery - базовый селект запрос
     * @return возвращает базовый запрос с джойнами.
     */
    public <R extends Record> SelectQuery<R> addSelectJoins(SelectQuery<R> baseQuery) {
        StreamEx.of(joinQueries)
                .sortedByInt(q -> {
                    // если одновременно есть и LEFT_OUTER_JOIN и INNER JOIN, то нужно выбрать INNER JOIN
                    // (иначе можем выбрать записи у которых нет данных в обязательных табличках)
                    if (q.getType() == JoinType.JOIN) {
                        return 0;
                    }
                    return 1;
                })
                .distinct(q -> q.getTable().getName())
                .forEach(q -> baseQuery.addJoin(q.getTable(), q.getType(), q.getConditions()));
        return baseQuery;
    }
}
