package ru.yandex.direct.multitype.entity;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Condition;
import org.jooq.JoinType;
import org.jooq.Table;

import static com.google.common.base.Preconditions.checkArgument;

@ParametersAreNonnullByDefault
public class JoinQuery {

    private final Table<?> table;
    private final JoinType type;
    private final Condition[] conditions;

    public JoinQuery(Table<?> table, JoinType type, Condition[] conditions) {
        checkArgument(conditions.length > 0, "Empty conditions list");
        this.table = table;
        this.type = type;
        this.conditions = conditions;
    }

    public JoinQuery(Table<?> table, JoinType type, Condition condition) {
        this(table, type, new Condition[]{condition});
    }

    public JoinType getType() {
        return type;
    }

    public Condition[] getConditions() {
        return conditions;
    }

    public Table<?> getTable() {
        return table;
    }
}
