package ru.yandex.direct.multitype.repository;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.Model;

@ParametersAreNonnullByDefault
public abstract class AbstractRepositoryTypeSupport<T extends Model, A, U>
        implements RepositoryTypeSupport<T, A, U> {
    private final DslContextProvider dslContextProvider;

    public AbstractRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    protected DSLContext dslContext(int shard) {
        return dslContextProvider.ppc(shard);
    }

    @Override
    public void updateAdditionTables(DSLContext context,
                                     U updateParameters,
                                     Collection<AppliedChanges<T>> appliedChanges) {
    }

    @Override
    public void insertToAdditionTables(DSLContext context,
                                       A addModelParametersContainer,
                                       Collection<T> models) {
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<T> models) {
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, T model) {
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<T>> appliedChanges) {
    }
}
