package ru.yandex.direct.multitype.repository.container;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Контейнер для операции обновления строк таблицы, работающий с двумя множествами:
 * 1. старые строки - те, которые сейчас в таблице
 * 2. новые строки - те, которые должны быть в таблице
 * <p>
 * Для каждого из этих множеств отдаёт подмножество:
 * 1. для старых строк выделяет те, которые нужно удалить (оставшиеся трогать не нужно)
 * 2. для новых строк выделяет те, которые нужно добавить или обновить (оставшиейся уже есть в таблице, поэтому
 * их можно пропустить)
 * <p>
 * Если позже для этих подмножеств произвести операции удаления и добавления/обновления соотвественно, то таблица
 * должна принять желаемый вид, т.е. трансформироваться из новой в старую.
 * <p>
 * Стоит учитывать, что в общем случае {@link #getRowsToDelete()} и {@link #getRowsToAddOrUpdate()} могут отдавать
 * строки с одинаковым primary key и тогда важно сначала удалить строки и только позже добавить или обновить,
 * поскольку при удалении скорее всего будут удалять по primary key, не проверяя остальные поля.
 * <p>
 * Конечная имплементация, зная как именно производятся операции удаления и обновления/добавления, а так же структуру
 * таблицы может эффективно выделять требуемые подмножества. Например, зная primary key таблицы можно разбивать так,
 * чтобы результат {@link #getRowsToDelete()} и {@link #getRowsToAddOrUpdate()} не пересекался по primary key.
 */
@ParametersAreNonnullByDefault
public interface AddOrUpdateAndDeleteContainer<T> {

    /**
     * Получить строки для удаления.
     * <p>В общем случае результат этого метода должен быть использован до {@link #getRowsToAddOrUpdate()},
     * см. описание класса.
     */
    Collection<T> getRowsToDelete();

    /**
     * Получить строки для добавления или обновления.
     * <p>В общем случае результат этого метода должен быть использован после {@link #getRowsToDelete()},
     * см. описание класса.
     */
    Collection<T> getRowsToAddOrUpdate();

}
