package ru.yandex.direct.multitype.repository.filter;

import org.jooq.Record;
import org.jooq.SelectQuery;

import static com.google.common.base.Preconditions.checkArgument;

abstract class AbstractFilter implements Filter {

    @Override
    public <R extends Record> SelectQuery<R> apply(SelectQuery<R> query) {
        // предотвращаем появление пустого массива в запросе, вроде 'WHERE ... IN ()'
        checkArgument(!isEmpty(), "filter data must not be empty");
        addInnerJoin(query);
        addWhere(query);
        return query;
    }

    protected abstract <R extends Record> void addWhere(SelectQuery<R> query);

    protected abstract <R extends Record> void addInnerJoin(SelectQuery<R> query);
}
