package ru.yandex.direct.multitype.repository.filter;


import javax.annotation.Nullable;

import org.jooq.Condition;
import org.jooq.Record;
import org.jooq.SelectQuery;
import org.jooq.TableLike;

public abstract class ConditionFilter extends AbstractFilter {

    private final TableLike<?> joinTable;
    private final Condition joinCondition;

    public ConditionFilter() {
        this(null, null);
    }

    public ConditionFilter(@Nullable TableLike<?> joinTable,
                           @Nullable Condition joinCondition) {
        this.joinTable = joinTable;
        this.joinCondition = joinCondition;
    }

    @Override
    protected final <R extends Record> void addWhere(SelectQuery<R> query) {
        query.addConditions(getCondition());
    }

    protected abstract Condition getCondition();

    @Override
    protected final <R extends Record> void addInnerJoin(SelectQuery<R> query) {
        if (joinTable == null) {
            return;
        }
        query.addJoin(joinTable, joinCondition);
    }
}
