package ru.yandex.direct.multitype.repository.filter;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.TableLike;

import static org.jooq.impl.DSL.inline;
import static ru.yandex.direct.dbutil.SqlUtils.fieldFromJson;

public class ConditionFilterFactory {
    private ConditionFilterFactory() {
    }

    public static Filter multipleConditionFilter(ConditionFilter... conditionFilters) {
        return new MultipleConditionFilter(conditionFilters);
    }

    public static <T> ConditionFilter whereEqFilter(Field<T> field,
                                                    T data) {
        return new DataFilter<>(data) {
            @Override
            protected Condition getCondition() {
                return field.eq(data);
            }
        };
    }

    public static <T> ConditionFilter whereEqFilter(Field<T> field,
                                                    T data,
                                                    TableLike<?> joinTable,
                                                    Condition joinCondition) {
        return new DataFilter<>(data, joinTable, joinCondition) {
            @Override
            protected Condition getCondition() {
                return field.eq(data);
            }
        };
    }

    public static <T> ConditionFilter whereJsonFieldEqFilter(Field<String> field,
                                                             String jsonField,
                                                             Class<T> fieldClass,
                                                             T data) {
        return new DataFilter<>(data) {
            @Override
            protected Condition getCondition() {
                return fieldFromJson(field, jsonField, fieldClass).equal(inline(data));
            }
        };
    }

    public static <T> ConditionFilter whereInFilter(Field<T> field,
                                                    Collection<T> dataList) {
        return new DataListFilter<>(dataList) {
            @Override
            protected Condition getCondition() {
                return field.in(dataList);
            }
        };

    }

    public static <T> ConditionFilter whereInFilter(Field<T> field,
                                                    Collection<T> dataList,
                                                    TableLike<?> joinTable,
                                                    Condition joinCondition) {
        return new DataListFilter<>(dataList, joinTable, joinCondition) {
            @Override
            protected Condition getCondition() {
                return field.in(dataList);
            }
        };
    }

    public static <T> ConditionFilter whereNotInFilter(Field<T> field,
                                                    Collection<T> dataList) {
        return new DataListFilter<>(dataList) {
            @Override
            protected Condition getCondition() {
                return field.notIn(dataList);
            }
        };

    }

    public static <T> ConditionFilter lessThan(Field<T> field,
                                               Field<T> dataField) {
        return new DataFilter<>(dataField) {
            @Override
            protected Condition getCondition() {
                return field.lessThan(dataField);
            }
        };
    }

    public static <T> ConditionFilter lessThan(Field<T> field,
                                               T data) {
        return new DataFilter<>(data) {
            @Override
            protected Condition getCondition() {
                return field.lessThan(data);
            }
        };
    }

    public static <T> ConditionFilter lessThan(Field<T> field,
                                               T data,
                                               TableLike<?> joinTable,
                                               Condition joinCondition) {
        return new DataFilter<>(data, joinTable, joinCondition) {
            @Override
            protected Condition getCondition() {
                return field.lessThan(data);
            }
        };
    }

    public static <T> ConditionFilter greaterThan(Field<T> field,
                                                  Field<T> dataField) {
        return new DataFilter<>(dataField) {
            @Override
            protected Condition getCondition() {
                return field.greaterThan(dataField);
            }
        };
    }

    public static <T> ConditionFilter greaterThan(Field<T> field,
                                                  T data) {
        return new DataFilter<>(data) {
            @Override
            protected Condition getCondition() {
                return field.greaterThan(data);
            }
        };
    }

    public static ConditionFilter setFieldContains(Field<String> field, String subString) {
        return new DataFilter<>(subString) {
            @Override
            protected Condition getCondition() {
                return field.contains(subString);
            }
        };
    }

}
