package ru.yandex.direct.multitype.repository.filter;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.TableLike;

@ParametersAreNonnullByDefault
public abstract class DataFilter<T> extends ConditionFilter {

    private final T data;

    public DataFilter(T data) {
        this(data, null, null);
    }

    public DataFilter(T data, @Nullable TableLike<?> joinTable, @Nullable Condition joinCondition) {
        super(joinTable, joinCondition);
        this.data = data;
    }

    @Override
    public boolean isEmpty() {
        return data == null;
    }

}
