package ru.yandex.direct.multitype.repository.filter;

import java.util.Collection;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.TableLike;

@ParametersAreNonnullByDefault
public abstract class DataListFilter<T> extends ConditionFilter {

    private final Collection<T> data;

    public DataListFilter(Collection<T> data) {
        this(data, null, null);
    }

    public DataListFilter(Collection<T> data, @Nullable TableLike<?> joinTable, @Nullable Condition joinCondition) {
        super(joinTable, joinCondition);
        this.data = data;
    }

    @Override
    public boolean isEmpty() {
        return data.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DataListFilter<?> that = (DataListFilter<?>) o;
        return Objects.equals(data, that.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(data);
    }

}
