package ru.yandex.direct.multitype.repository.filter;

import java.util.List;

import org.jooq.Record;
import org.jooq.SelectQuery;

class MultipleConditionFilter extends AbstractFilter {

    private final List<ConditionFilter> filters;

    public MultipleConditionFilter(ConditionFilter... filters) {
        this.filters = List.of(filters);
    }

    @Override
    protected <R extends Record> void addWhere(SelectQuery<R> query) {
        filters.forEach(f -> f.addWhere(query));
    }

    @Override
    public boolean isEmpty() {
        return filters.isEmpty() || filters.stream().anyMatch(ConditionFilter::isEmpty);
    }

    @Override
    protected <R extends Record> void addInnerJoin(SelectQuery<R> query) {
        filters.forEach(f -> f.addInnerJoin(query));
    }
}
