package ru.yandex.direct.multitype.repository.filter;

import java.time.LocalDate;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.impl.DSL;

@ParametersAreNonnullByDefault
public class SqlFunctions {

    // https://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html#function_weekday
    public static final Long SQL_MONDAY = 0L;
    public static final Long SQL_TUESDAY = 1L;
    public static final Long SQL_WEDNESDAY = 2L;
    public static final Long SQL_THURSDAY = 3L;
    public static final Long SQL_FRIDAY = 4L;
    public static final Long SQL_SATURDAY = 5L;
    public static final Long SQL_SUNDAY = 6L;

    public static Field<Long> sqlWeekday(Field<LocalDate> field) {
        return DSL.function("weekday", Long.class, DSL.field(field));
    }

}
