package ru.yandex.direct.multitype.service.type.add;

import java.util.List;

import org.jooq.DSLContext;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.multitype.typesupport.TypeSupport;

/**
 * @param <T> - конечный тип, который обрабатывается репозиторием
 * @param <A> - контейнер, который передается в методы добавления
 * @param <B> - контейнер, который передается в методы добавления
 */
public interface AddOperationTypeSupport<T extends Model, A, B> extends TypeSupport<T> {
    /**
     * Выполнить действия с моделями после выполнения превалидации
     */
    void onPreValidated(A addModelContainer, List<T> models);

    /**
     * Выполнить действия с моделями после выполнения всей валидации
     */
    void onModelsValidated(A addModelContainer, List<T> models);

    /**
     * Выполнить действие до создания объекта
     */
    void beforeExecution(A addModelContainer, List<T> models);

    /**
     * Добавить данные в контейнер, для последующего применения действий
     * Например для сброса статуса синхронизации с БК для групп и баннеров
     * Или добавления в очередь на отправку нотификаций в Баланс
     */
    void addToAdditionalActionsContainer(B additionalActionsContainer,
                                         A addModelContainer,
                                         List<T> models);

    /**
     * Обновить в рамках транзакции смежные сущности
     */
    void updateRelatedEntitiesInTransaction(
            DSLContext dslContext,
            A addModelContainer,
            List<T> models);

    /**
     * Выполнить действия после создания
     */
    void afterExecution(A addModelContainer, List<T> models);

}
