package ru.yandex.direct.multitype.service.type.add;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;

import ru.yandex.direct.model.Model;

import static ru.yandex.direct.multitype.typesupport.TypeSupportUtils.getObjectsByTypeSupports;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public abstract class AddOperationTypeSupportFacade<T extends Model, A, B> {
    private final List<? extends AddOperationTypeSupport<? extends T, A, B>> supports;


    public AddOperationTypeSupportFacade(List<? extends AddOperationTypeSupport<? extends T, A, B>> supports) {
        this.supports = supports;
    }

    public void onPreValidated(A addContainer,
                               List<? extends T> models) {
        getModelsGroupedByTypeSupports(models)
                .forEach((support, typedModels) -> onPreValidated(support, addContainer, typedModels));
    }

    private <M extends T> void onPreValidated(
            AddOperationTypeSupport<M, A, B> support,
            A addContainer,
            List<? extends T> typedModels) {
        //noinspection unchecked
        List<M> models = mapList(typedModels, c -> (M) c);
        support.onPreValidated(addContainer, models);
    }

    public void onModelsValidated(A addContainer,
                               List<? extends T> models) {
        getModelsGroupedByTypeSupports(models)
                .forEach((support, typedModels) -> onModelsValidated(support, addContainer, typedModels));
    }

    private <M extends T> void onModelsValidated(
            AddOperationTypeSupport<M, A, B> support,
            A addContainer,
            List<? extends T> typedModels) {
        //noinspection unchecked
        List<M> models = mapList(typedModels, c -> (M) c);
        support.onModelsValidated(addContainer, models);
    }

    public void beforeExecution(A addContainer,
                                List<? extends T> models) {
        getModelsGroupedByTypeSupports(models)
                .forEach((support, typedModels) -> beforeExecution(addContainer, support, typedModels));
    }

    private <M extends T> void beforeExecution(
            A addContainer,
            AddOperationTypeSupport<M, A, B> support,
            List<? extends T> typedModels) {
        //noinspection unchecked
        List<M> models = mapList(typedModels, c -> (M) c);
        support.beforeExecution(addContainer, models);
    }

    public void afterExecution(A addContainer,
                               List<? extends T> models) {
        getModelsGroupedByTypeSupports(models)
                .forEach((support, typedModels) -> afterExecution(addContainer, support, typedModels));
    }

    private <M extends T> void afterExecution(
            A addContainer,
            AddOperationTypeSupport<M, A, B> support,
            List<? extends T> typedModels) {
        //noinspection unchecked
        List<M> models = mapList(typedModels, c -> (M) c);
        support.afterExecution(addContainer, models);
    }

    public void addToAdditionalActionsContainer(
            B additionalContainer,
            A addContainer,
            Collection<? extends T> models) {
        getModelsGroupedByTypeSupports(models).forEach((support, changes) ->
                addToAdditionalActionsContainer(additionalContainer, addContainer, changes, support));
    }

    private <M extends T> void addToAdditionalActionsContainer(
            B additionalContainer,
            A addContainer,
            List<? extends T> typedModels,
            AddOperationTypeSupport<M, A, B> support) {
        //noinspection unchecked
        List<M> models = mapList(typedModels, c -> (M) c);
        support.addToAdditionalActionsContainer(additionalContainer, addContainer, models);
    }

    public void updateRelatedEntitiesInTransaction(DSLContext dslContext,
                                                   A addContainer,
                                                   List<? extends T> models) {
        getModelsGroupedByTypeSupports(models)
                .forEach((support, typedModels) ->
                        updateRelatedEntitiesInTransaction(dslContext, addContainer, support, typedModels));
    }

    private <M extends T> void updateRelatedEntitiesInTransaction(
            DSLContext dslContext,
            A addContainer,
            AddOperationTypeSupport<M, A, B> support,
            List<? extends T> typedModels) {
        //noinspection unchecked
        List<M> models = mapList(typedModels, c -> (M) c);
        support.updateRelatedEntitiesInTransaction(dslContext, addContainer, models);
    }

    private Map<? extends AddOperationTypeSupport<? extends T, A, B>, ? extends List<? extends T>>
    getModelsGroupedByTypeSupports(
            Collection<? extends T> models) {
        return getObjectsByTypeSupports(supports, models, Object::getClass);
    }
}
