package ru.yandex.direct.multitype.service.type.update;

import java.util.List;

import org.jooq.DSLContext;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelWithId;

public abstract class AbstractUpdateOperationTypeSupport<
        T extends ModelWithId, A extends UpdateOperationContainer<?>, B, C>
        implements UpdateOperationTypeSupport<T, A, B, C> {

    @Override
    public void onModelChangesValidated(A updateContainer, List<ModelChanges<T>> validModelChanges) {
    }

    @Override
    public void onChangesApplied(A updateContainer, List<AppliedChanges<T>> appliedChanges) {
    }

    @Override
    public void onAppliedChangesValidated(A updateContainer, List<AppliedChanges<T>> appliedChanges) {
    }

    @Override
    public void beforeExecution(A updateContainer, List<AppliedChanges<T>> appliedChanges) {
    }

    @Override
    public void addToAdditionalActionsContainer(B additionalActionsContainer, A updateContainer,
                                                List<AppliedChanges<T>> appliedChanges) {
    }

    @Override
    public void beforeExecutionInTransaction(DSLContext dslContext, B additionalActionsContainer, A updateContainer,
                                             List<AppliedChanges<T>> appliedChanges) {
    }

    @Override
    public void updateRelatedEntitiesInTransaction(DSLContext dslContext, A updateContainer,
                                                   List<AppliedChanges<T>> appliedChanges) {
    }

    @Override
    public void updateRelatedEntitiesOutOfTransaction(A updateContainer, List<AppliedChanges<T>> appliedChanges) {
    }

    @Override
    public void updateRelatedEntitiesOutOfTransactionWithModelChanges(A updateContainer,
                                                                      List<ModelChanges<T>> modelChanges,
                                                                      List<AppliedChanges<T>> appliedChanges) {
    }

    @Override
    public void afterExecution(A updateContainer, List<AppliedChanges<T>> appliedChanges) {
    }

    @Override
    public boolean needModeration(C container, AppliedChanges<T> appliedChanges) {
        return false;
    }

    @Override
    public boolean needBsResync(AppliedChanges<T> appliedChanges) {
        return false;
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<T> appliedChanges) {
        return false;
    }
}
