package ru.yandex.direct.multitype.service.validation.type.add;

import java.util.List;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.multitype.typesupport.TypeSupport;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public interface AddValidationTypeSupport<T extends Model, V> extends TypeSupport<T> {
    /**
     * Делает предварительные проверки для моделей
     */
    ValidationResult<List<T>, Defect> preValidate(V container, ValidationResult<List<T>, Defect> vr);

    /**
     * Делает проверки моделей, которые могут быть сохранены в бд.
     */
    ValidationResult<List<T>, Defect> validate(V container, ValidationResult<List<T>, Defect> vr);
}
