package ru.yandex.direct.multitype.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.select;

@ParametersAreNonnullByDefault
public class AddValidationTypeSupportFacade<T extends Model, C> {
    private final List<? extends AddValidationTypeSupport<? extends T, C>> supports;

    public AddValidationTypeSupportFacade(
            List<? extends AddValidationTypeSupport<? extends T, C>> supports) {
        this.supports = supports;
    }


    public void preValidate(C container, ValidationResult<? extends List<? extends T>, Defect> vr) {
        supports.forEach(support -> preValidateBySupport(support, container, vr));
    }

    private <M extends T> void preValidateBySupport(
            AddValidationTypeSupport<M, C> support,
            C container,
            ValidationResult<? extends List<? extends T>, Defect> vr) {
        var subVr = select(vr, support.getTypeClass());

        if (!subVr.getValue().isEmpty()) {
            support.preValidate(container, subVr);
        }
    }

    public void validate(C container, ValidationResult<? extends List<? extends T>, Defect> vr) {
        supports.forEach(support -> validateBySupport(support, container, vr));
    }

    private <M extends T> void validateBySupport(
            AddValidationTypeSupport<M, C> support,
            C container,
            ValidationResult<? extends List<? extends T>, Defect> vr) {
        var subVr = select(vr, support.getTypeClass());

        if (!subVr.getValue().isEmpty()) {
            support.validate(container, subVr);

            // Перебросить ошибки уровня операции в validationResult. Ошибки уровня операции содержат ошибки на всю
            // коллекцию добавялемых стратегий. Например, ошибка превышения лимита общего количества стратегий.
            subVr.getErrors().forEach(error -> {
                if (!vr.getErrors().contains(error)) {
                    vr.addError(error);
                }
            });
        }
    }
}
