package ru.yandex.direct.multitype.service.validation.type.update;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.multitype.typesupport.TypeSupport;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public interface UpdateValidationTypeSupport<T extends ModelWithId, C> extends TypeSupport<T> {

    /**
     * Делает проверки ModelChanges, не зависящие от уже сохраненных в базе данных. Должен редко использоваться.
     * <p>Вызов не будет оптимизирован {@link ru.yandex.direct.multitype.typesupport.TypeSupportAffectionHelper}-ом
     * потому что невозможно распознать передано новое значение или совпадающее с текущим.
     * <p>Поэтому как правило лучше использовать {@link #validate(Object, ValidationResult, Map)} и метод
     * {@link ru.yandex.direct.model.AppliedChanges#changed(ModelProperty)} если требуется понять было ли передано
     * новое значение.
     */
    ValidationResult<List<ModelChanges<T>>, Defect> preValidate(C container,
                                                                ValidationResult<List<ModelChanges<T>>, Defect> vr);

    /**
     * Делает проверки ModelChanges, зависящие от уже сохраненных данных.
     * В unmodifiedValidModels передаются только валидные модели.
     */
    ValidationResult<List<ModelChanges<T>>, Defect> validateBeforeApply(
            C container,
            ValidationResult<List<ModelChanges<T>>, Defect> vr,
            Map<Long, T> unmodifiedValidModels);

    /**
     * Делает проверки модели, которая может быть сохранена в бд.
     */
    default ValidationResult<List<T>, Defect> validate(
            C container,
            ValidationResult<List<T>, Defect> vr,
            Map<Integer, AppliedChanges<T>> appliedChangesForValidModelChanges) {
        return validate(container, vr);
    }

    /**
     * Версия метода validate, которая не учитывает appliedChangesForValidModelChanges.
     * Не рекомендуется вызывать этот метод, всегда стоит вызывать полную версию метода, т.к. иногда для валидации
     * важно знать предыдущее состояние объекта.
     * <p>Вызывать этот метод рискованно - если саппорт использует полную версию метода, то валидация вообще не будет
     * вызвана.
     * <p>Пока этот метод оставлен, потому что не хотелось переделывать 100 наследников.
     */
    ValidationResult<List<T>, Defect> validate(C container, ValidationResult<List<T>, Defect> vr);
}
