package ru.yandex.direct.multitype.typesupport;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer;

/**
 * Тонкости:
 * Если в ModelChanges придёт значение, совпдаающее с текущим, то мы будем поначалу вызывать методы саппорта, а потом
 * (на этапе AppliedChanges) можем перестать это делать.
 */
@ParametersAreNonnullByDefault
public class TypeSupportAffectionHelper<T extends Model> {

    private final Set<Class<? extends T>> whiteListSupportTypeClass;

    public TypeSupportAffectionHelper(Set<Class<? extends T>> whiteListSupportTypeClass) {
        this.whiteListSupportTypeClass = whiteListSupportTypeClass;
    }

    public <M extends ModelWithId> Map<Integer, ? extends AppliedChanges<? extends M>>
    selectAppliedChangesThatAffectSupport(
            Map<Integer, ? extends AppliedChanges<? extends M>> appliedChangesForValidModelChanges,
            Class<?> supportClass) {
        return EntryStream.of(appliedChangesForValidModelChanges)
                .filterValues(ac -> isAppliedChangesAffectsSupport(ac, supportClass))
                .toMap();
    }

    public List<? extends ModelChanges<? extends T>> selectModelChangesThatAffectSupport(
            UpdateOperationContainer<?> updateOperationContainer,
            Collection<? extends ModelChanges<? extends T>> modelChanges,
            Class<?> supportClass) {
        return StreamEx.of(modelChanges)
                .filter(mc -> isModelChangesAffectsSupport(updateOperationContainer, mc, supportClass))
                .toList();
    }

    public List<? extends AppliedChanges<? extends T>> selectAppliedChangesThatAffectSupport(
            Collection<? extends AppliedChanges<? extends T>> appliedChanges,
            Class<?> supportClass) {
        return StreamEx.of(appliedChanges)
                .filter(ac -> isAppliedChangesAffectsSupport(ac, supportClass))
                .toList();
    }

    public boolean isModelChangesAffectsSupport(
            UpdateOperationContainer<?> updateOperationContainer,
            ModelChanges<?> modelChanges,
            Class<?> supportClass) {
        return supportClass.isAssignableFrom(updateOperationContainer.getRuntimeClass(modelChanges.getId()))
                && (isInWhiteList(supportClass)
                || (modelChanges.getChangedPropsNames().stream().anyMatch(
                changedProperty -> changedProperty.getModelClass().isAssignableFrom(supportClass))));
    }

    public boolean isAppliedChangesAffectsSupport(AppliedChanges<?> appliedChanges, Class<?> supportClass) {
        return supportClass.isAssignableFrom(appliedChanges.getModel().getClass())
                && (isInWhiteList(supportClass)
                || appliedChanges.getActuallyChangedProps().stream().anyMatch(
                changedProperty -> changedProperty.getModelClass().isAssignableFrom(supportClass)));
    }

    private boolean isInWhiteList(Class<?> supportClass) {
        return whiteListSupportTypeClass.stream()
                .anyMatch(whiteSupportClass -> whiteSupportClass.isAssignableFrom(supportClass));
    }

}
