package ru.yandex.direct.multitype.typesupport;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.model.Model;

@ParametersAreNonnullByDefault
public class TypeSupportUtils {

    private TypeSupportUtils() {
    }

    public static <S extends TypeSupport<?>> List<S> getSupportsByClass(List<S> supports, Class<?> clazz) {
        return StreamEx.of(supports)
                .mapToEntry(TypeSupport::getTypeClass, Function.identity())
                .filterKeys(supportClass -> supportClass.isAssignableFrom(clazz))
                .values()
                .toList();
    }

    public static <T, M extends T, S extends TypeSupport<? extends T>, R extends TypeSupport<? super M>> List<? extends R> getSupportsByClassWithExactTypes(
            List<S> supports, Class<M> clazz) {
        //noinspection unchecked
        return StreamEx.of(supports)
                .mapToEntry(TypeSupport::getTypeClass, Function.identity())
                .filterKeys(supportClass -> supportClass.isAssignableFrom(clazz))
                .mapValues(support -> (R)support)
                .values()
                .toList();
    }


    public static <T extends Model, S extends TypeSupport<? extends T>> List<S> getSupportsByClasses(
            List<S> supports,
            Collection<Class<? extends T>> classes) {
        return StreamEx.of(supports)
                .mapToEntry(TypeSupport::getTypeClass, Function.identity())
                .filterKeys(supportClass -> classes.stream().anyMatch(supportClass::isAssignableFrom))
                .values()
                .toList();
    }

    /**
     * Группирует список объектов по саппортам, которые их поддерживают
     */
    public static <S extends TypeSupport<?>, O> Map<S, ? extends List<O>> getObjectsByTypeSupports(
            List<S> supports, Collection<O> objects, Function<O, Class<?>> modelTypeGetter) {
        return StreamEx.of(supports)
                .mapToEntry(TypeSupport::getTypeClass)
                .mapValues(supportClass -> selectObjectsForSupportedClass(objects, supportClass, modelTypeGetter))
                .removeValues(List::isEmpty)
                .toMap();
    }

    public static <O> List<O> selectObjectsForSupportedClass(Collection<O> objects,
                                                             Class<?> supportClass,
                                                             Function<O, Class<?>> modelTypeGetter) {
        return StreamEx.of(objects)
                .mapToEntry(modelTypeGetter, Function.identity())
                .filterKeys(supportClass::isAssignableFrom)
                .values()
                .toList();
    }

}
