package ru.yandex.direct.mysql;

import java.util.Locale;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

/**
 * Basic MySQL data type
 */
public enum MySQLDataType {
    UNKNOWN("any"),

    // Numeric data types
    BIT("bit"),
    TINYINT("tinyint"),
    SMALLINT("smallint"),
    MEDIUMINT("mediumint"),
    INT("int"),
    BIGINT("bigint"),
    DECIMAL("decimal"),
    FLOAT("float"),
    DOUBLE("double"),

    // Date and time types
    DATE("date"),
    DATETIME("datetime"),
    TIMESTAMP("timestamp"),
    TIME("time"),
    YEAR("year"),

    // String types
    CHAR("char"),
    VARCHAR("varchar"),
    BINARY("binary"),
    VARBINARY("varbinary"),
    TINYBLOB("tinyblob"),
    TINYTEXT("tinytext"),
    BLOB("blob"),
    TEXT("text"),
    MEDIUMBLOB("mediumblob"),
    MEDIUMTEXT("mediumtext"),
    LONGBLOB("longblob"),
    LONGTEXT("longtext"),
    ENUM("enum"),
    SET("set"),
    JSON("json");

    private final String value;

    MySQLDataType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    private static final Map<String, MySQLDataType> typeByName;

    static {
        ImmutableMap.Builder<String, MySQLDataType> tmp = ImmutableMap.builder();
        for (MySQLDataType type : MySQLDataType.values()) {
            tmp.put(type.value, type);
        }
        typeByName = tmp.build();
    }

    public static MySQLDataType byName(String name) {
        MySQLDataType type = typeByName.get(name.trim().toLowerCase(Locale.ROOT));
        if (type == null) {
            type = UNKNOWN;
        }
        return type;
    }
}
