package ru.yandex.direct.mysql;

import java.util.Objects;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Представление и парсер MySQL Global Transaction Identifier
 */
public class MySQLGtid {
    private final String src;
    private final long scn;

    public MySQLGtid(String src, long scn) {
        this.src = src;
        this.scn = scn;
    }

    /**
     * Парсинг строки вида "5507efdf-ac17-f35e-5cad-26645da19341:2218046860"
     */
    public static MySQLGtid of(String str) {
        checkNotNull(str);
        int colonPos = str.indexOf(':');
        checkArgument(colonPos > 0, "Incorrect gtid format");
        String src = str.substring(0, colonPos);
        long scn = Long.parseLong(str.substring(colonPos + 1));
        return new MySQLGtid(src, scn);
    }

    /**
     * @return - идентификатор сервера, на котором произошла транзакция
     */
    public String getSrc() {
        return src;
    }

    /**
     * @return - порадковый номер транзакции в рамках src
     */
    public long getScn() {
        return scn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MySQLGtid mySQLGtid = (MySQLGtid) o;
        return scn == mySQLGtid.scn &&
                Objects.equals(src, mySQLGtid.src);
    }

    @Override
    public int hashCode() {
        return Objects.hash(src, scn);
    }
}
