package ru.yandex.direct.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Objects;

import ru.yandex.direct.utils.db.MySQLConnector;

public class MySQLSimpleConnector implements MySQLConnector {
    private String host;
    private int port;
    private String username;
    private String password;

    public MySQLSimpleConnector(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    @Override
    public String getHost() {
        return host;
    }

    @Override
    public int getPort() {
        return port;
    }

    @Override
    public String getUsername() {
        return username;
    }

    @Override
    public String getPassword() {
        return password;
    }

    @Override
    public Connection connect() throws SQLException {
        return MySQLUtils.connect(host, port, username, password);
    }

    @Override
    public Connection connect(Duration timeout) throws SQLException {
        return MySQLUtils.connect(host, port, username, password, timeout);
    }

    @Override
    public String toString() {
        return "MySQLSimpleConnector{'" + host + "', " + port + ", '" + username + "'}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MySQLSimpleConnector that = (MySQLSimpleConnector) o;
        return port == that.port &&
                Objects.equals(host, that.host) &&
                Objects.equals(username, that.username) &&
                Objects.equals(password, that.password);
    }

    @Override
    public int hashCode() {
        return Objects.hash(host, port, username, password);
    }
}
