package ru.yandex.direct.mysql.schema;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;

public class KeyColumn {
    private final String name;
    private final Integer part;
    private final boolean isNullable;

    @JsonCreator
    public KeyColumn(@JsonProperty("name") String name, @JsonProperty("part") Integer part,
                     @JsonProperty("is_nullable") boolean isNullable) {
        this.name = Objects.requireNonNull(name);
        this.part = part;
        this.isNullable = isNullable;
    }

    @JsonGetter("name")
    public String getName() {
        return name;
    }

    @JsonGetter("part")
    public Integer getPart() {
        return part;
    }

    @JsonGetter("is_nullable")
    public boolean isNullable() {
        return isNullable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyColumn)) {
            return false;
        }

        KeyColumn keyColumn = (KeyColumn) o;

        if (isNullable != keyColumn.isNullable) {
            return false;
        }
        if (!name.equals(keyColumn.name)) {
            return false;
        }
        return part != null ? part.equals(keyColumn.part) : keyColumn.part == null;

    }

    @Override
    public int hashCode() {
        int result = name.hashCode();
        result = 31 * result + (part != null ? part.hashCode() : 0);
        result = 31 * result + (isNullable ? 1 : 0);
        return result;
    }
}
