package ru.yandex.direct.mysql.schema;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class KeySchema {
    private final String name;
    private final String type;
    private final boolean isUnique;
    private final List<KeyColumn> columns;

    @JsonCreator
    public KeySchema(@JsonProperty("name") String name, @JsonProperty("type") String type,
                     @JsonProperty("is_unique") boolean isUnique, @JsonProperty("columns") List<KeyColumn> columns) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.isUnique = isUnique;
        this.columns = Objects.requireNonNull(columns);
    }

    @JsonGetter("name")
    public String getName() {
        return name;
    }

    @JsonGetter("type")
    public String getType() {
        return type;
    }

    @JsonGetter("is_unique")
    public boolean isUnique() {
        return isUnique;
    }

    @JsonIgnore
    public boolean isPrimary() {
        return "PRIMARY".equals(getName());
    }

    @JsonGetter("columns")
    public List<KeyColumn> getColumns() {
        return columns;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeySchema)) {
            return false;
        }

        KeySchema keySchema = (KeySchema) o;

        if (isUnique != keySchema.isUnique) {
            return false;
        }
        if (!name.equals(keySchema.name)) {
            return false;
        }
        if (!type.equals(keySchema.type)) {
            return false;
        }
        return columns.equals(keySchema.columns);

    }

    @Override
    public int hashCode() {
        int result = name.hashCode();
        result = 31 * result + type.hashCode();
        result = 31 * result + (isUnique ? 1 : 0);
        result = 31 * result + columns.hashCode();
        return result;
    }
}
