package ru.yandex.direct.mysql.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;

import ru.yandex.direct.mysql.schema.ServerSchema;

/**
 * Вспомогательный скрипт для дампа схемы с указанного сервера
 */
public class DumpServerSchema {
    public static void main(String[] args) throws SQLException, IOException {
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String username = args[2];
        String password = args[3];
        String filename = args[4];
        try (Connection conn = DriverManager
                .getConnection(String.format("jdbc:mysql://address=(protocol=tcp)(host=%s)(port=%d)", host, port),
                        username, password)) {
            ServerSchema schema = ServerSchema.dump(conn);
            String json = schema.toJson();
            Files.write(Paths.get(filename), Collections.singletonList(json));
        }
    }
}
