package ru.yandex.direct.mysql.slowlog.parser;

import java.time.Instant;

public class ParsedSlowLogRawRecord {
    private final Instant timestamp;
    private final String queryText;
    private final String userName;
    private final String userSecondName;
    private final String userHost;
    private final String userIp;
    private final long connectionId;
    private final String schema;
    private final int lastErrorNumber;
    private final int killedCode;
    private final double queryTimeInSeconds;
    private final double lockTimeInSeconds;
    private final long rowsSentCount;
    private final long rowsExaminedCount;
    private final long rowsAffectedCount;
    private final long bytesSentCount;
    private final int tempTablesCount;
    private final int tempTablesOnDiskCount;
    private final long tempTablesSizesInBytes;
    private final long transactionId;
    private final boolean hasQcHit;
    private final boolean hasFullScan;
    private final boolean hasFullJoin;
    private final boolean hasTempTables;
    private final boolean hasTempTablesOnDisk;
    private final boolean hasFileSort;
    private final boolean hasFileSortOnDisk;;
    private final int mergePassesCount;
    private final int innoDbIoReadOperationsCount;
    private final long innoDbIoReadBytesCount;
    private final double innoDbReadWaitInSeconds;
    private final double innoDbRecordsLockWaitInSeconds;
    private final double innoQbQueueWaitInSeconds;
    private final int innoDbPagesCountDistinct;

    public ParsedSlowLogRawRecord(
            Instant timestamp,
            String queryText,
            String userName,
            String userSecondName,
            String userHost,
            String userIp,
            long connectionId,
            String schema,
            int lastErrorNumber,
            int killedCode,
            double queryTimeInSeconds,
            double lockTimeInSeconds,
            long rowsSentCount,
            long rowsExaminedCount,
            long rowsAffectedCount,
            long bytesSentCount,
            int tempTablesCount,
            int tempTablesOnDiskCount,
            long tempTablesSizesInBytes,
            long transactionId,
            boolean hasQcHit,
            boolean hasFullScan,
            boolean hasFullJoin,
            boolean hasTempTables,
            boolean hasTempTablesOnDisk,
            boolean hasFileSort,
            boolean hasFileSortOnDisk,
            int mergePassesCount,
            int innoDbIoReadOperationsCount,
            long innoDbIoReadBytesCount,
            double innoDbReadWaitInSeconds,
            double innoDbRecordsLockWaitInSeconds,
            double innoQbQueueWaitInSeconds,
            int innoDbPagesCountDistinct) {
        this.timestamp = timestamp;
        this.queryText = queryText;
        this.userName = userName;
        this.userSecondName = userSecondName;
        this.userHost = userHost;
        this.userIp = userIp;
        this.connectionId = connectionId;
        this.schema = schema;
        this.lastErrorNumber = lastErrorNumber;
        this.killedCode = killedCode;
        this.queryTimeInSeconds = queryTimeInSeconds;
        this.lockTimeInSeconds = lockTimeInSeconds;
        this.rowsSentCount = rowsSentCount;
        this.rowsExaminedCount = rowsExaminedCount;
        this.rowsAffectedCount = rowsAffectedCount;
        this.bytesSentCount = bytesSentCount;
        this.tempTablesCount = tempTablesCount;
        this.tempTablesOnDiskCount = tempTablesOnDiskCount;
        this.tempTablesSizesInBytes = tempTablesSizesInBytes;
        this.transactionId = transactionId;
        this.hasQcHit = hasQcHit;
        this.hasFullScan = hasFullScan;
        this.hasFullJoin = hasFullJoin;
        this.hasTempTables = hasTempTables;
        this.hasTempTablesOnDisk = hasTempTablesOnDisk;
        this.hasFileSort = hasFileSort;
        this.hasFileSortOnDisk = hasFileSortOnDisk;
        this.mergePassesCount = mergePassesCount;
        this.innoDbIoReadOperationsCount = innoDbIoReadOperationsCount;
        this.innoDbIoReadBytesCount = innoDbIoReadBytesCount;
        this.innoDbReadWaitInSeconds = innoDbReadWaitInSeconds;
        this.innoDbRecordsLockWaitInSeconds = innoDbRecordsLockWaitInSeconds;
        this.innoQbQueueWaitInSeconds = innoQbQueueWaitInSeconds;
        this.innoDbPagesCountDistinct = innoDbPagesCountDistinct;
    }

    public static ParsedSlowLogRecordBuilder builder() {
        return new ParsedSlowLogRecordBuilder();
    }

    public Instant getTimestamp() {
        return timestamp;
    }

    public String getQueryText() {
        return queryText;
    }

    public String getUserName() {
        return userName;
    }

    public String getUserSecondName() {
        return userSecondName;
    }

    public String getUserHost() {
        return userHost;
    }

    public String getUserIp() {
        return userIp;
    }

    public long getConnectionId() {
        return connectionId;
    }

    public String getSchema() {
        return schema;
    }

    public int getLastErrorNumber() {
        return lastErrorNumber;
    }

    public int getKilledCode() {
        return killedCode;
    }

    public double getQueryTimeInSeconds() {
        return queryTimeInSeconds;
    }

    public double getLockTimeInSeconds() {
        return lockTimeInSeconds;
    }

    public long getRowsSentCount() {
        return rowsSentCount;
    }

    public long getRowsExaminedCount() {
        return rowsExaminedCount;
    }

    public long getRowsAffectedCount() {
        return rowsAffectedCount;
    }

    public long getBytesSentCount() {
        return bytesSentCount;
    }

    public int getTempTablesCount() {
        return tempTablesCount;
    }

    public int getTempTablesOnDiskCount() {
        return tempTablesOnDiskCount;
    }

    public long getTempTablesSizesInBytes() {
        return tempTablesSizesInBytes;
    }

    public long getTransactionId() {
        return transactionId;
    }

    public boolean hasQcHit() {
        return hasQcHit;
    }

    public boolean hasFullScan() {
        return hasFullScan;
    }

    public boolean isHasFullJoin() {
        return hasFullJoin;
    }

    public boolean hasTempTables() {
        return hasTempTables;
    }

    public boolean hasTempTablesOnDisk() {
        return hasTempTablesOnDisk;
    }

    public boolean hasFileSort() {
        return hasFileSort;
    }

    public boolean hasFileSortOnDisk() {
        return hasFileSortOnDisk;
    }

    public int getMergePassesCount() {
        return mergePassesCount;
    }

    public int getInnoDbIoReadOperationsCount() {
        return innoDbIoReadOperationsCount;
    }

    public long getInnoDbIoReadBytesCount() {
        return innoDbIoReadBytesCount;
    }

    public double getInnoDbReadWaitInSeconds() {
        return innoDbReadWaitInSeconds;
    }

    public double getInnoDbRecordsLockWaitInSeconds() {
        return innoDbRecordsLockWaitInSeconds;
    }

    public double getInnoQbQueueWaitInSeconds() {
        return innoQbQueueWaitInSeconds;
    }

    public int getInnoDbPagesCountDistinct() {
        return innoDbPagesCountDistinct;
    }

    public static class ParsedSlowLogRecordBuilder {
        private Instant timestamp;
        private String queryText;
        private String userName;
        private String userSecondName;
        private String userHost;
        private String userIp;
        private long connectionId;
        private String schema;
        private int lastErrorNumber;
        private int killedCode;
        private double queryTimeInSeconds;
        private double lockTimeInSeconds;
        private long rowsSentCount;
        private long rowsExaminedCount;
        private long rowsAffectedCount;
        private long bytesSentCount;
        private int tempTablesCount;
        private int tempTablesOnDiskCount;
        private long tempTablesSizesInBytes;
        private long transactionId;
        private boolean hasQcHit;
        private boolean hasFullScan;
        private boolean hasFullJoin;
        private boolean hasTempTables;
        private boolean hasTempTablesOnDisk;
        private boolean hasFileSort;
        private boolean hasFileSortOnDisk;;
        private int mergePassesCount;
        private int innoDbIoReadOperationsCount;
        private long innoDbIoReadBytesCount;
        private double innoDbReadWaitInSeconds;
        private double innoDbRecordsLockWaitInSeconds;
        private double innoQbQueueWaitInSeconds;
        private int innoDbPagesCountDistinct;

        private ParsedSlowLogRecordBuilder() {

        }

        public ParsedSlowLogRecordBuilder withTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ParsedSlowLogRecordBuilder withQueryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public ParsedSlowLogRecordBuilder withUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public ParsedSlowLogRecordBuilder withUserSecondName(String userSecondName) {
            this.userSecondName = userSecondName;
            return this;
        }

        public ParsedSlowLogRecordBuilder withUserHost(String userHost) {
            this.userHost = userHost;
            return this;
        }

        public ParsedSlowLogRecordBuilder withUserIp(String userIp) {
            this.userIp = userIp;
            return this;
        }

        public ParsedSlowLogRecordBuilder withConnectionId(long connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public ParsedSlowLogRecordBuilder withSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public ParsedSlowLogRecordBuilder withLastErrorNumber(int lastErrorNumber) {
            this.lastErrorNumber = lastErrorNumber;
            return this;
        }

        public ParsedSlowLogRecordBuilder withKilledCode(int killedCode) {
            this.killedCode = killedCode;
            return this;
        }

        public ParsedSlowLogRecordBuilder withQueryTimeInSeconds(double queryTimeInSeconds) {
            this.queryTimeInSeconds = queryTimeInSeconds;
            return this;
        }

        public ParsedSlowLogRecordBuilder withLockTimeInSeconds(double lockTimeInSeconds) {
            this.lockTimeInSeconds = lockTimeInSeconds;
            return this;
        }

        public ParsedSlowLogRecordBuilder withRowsSentCount(long rowsSentCount) {
            this.rowsSentCount = rowsSentCount;
            return this;
        }

        public ParsedSlowLogRecordBuilder withRowsExaminedCount(long rowsExaminedCount) {
            this.rowsExaminedCount = rowsExaminedCount;
            return this;
        }

        public ParsedSlowLogRecordBuilder withRowsAffectedCount(long rowsAffectedCount) {
            this.rowsAffectedCount = rowsAffectedCount;
            return this;
        }

        public ParsedSlowLogRecordBuilder withBytesSentCount(long bytesSentCount) {
            this.bytesSentCount = bytesSentCount;
            return this;
        }

        public ParsedSlowLogRecordBuilder withTempTablesCount(int tempTablesCount) {
            this.tempTablesCount = tempTablesCount;
            return this;
        }

        public ParsedSlowLogRecordBuilder withTempTablesOnDiskCount(int tempTablesOnDiskCount) {
            this.tempTablesOnDiskCount = tempTablesOnDiskCount;
            return this;
        }

        public ParsedSlowLogRecordBuilder withTempTablesSizesInBytes(long tempTablesSizesInBytes) {
            this.tempTablesSizesInBytes = tempTablesSizesInBytes;
            return this;
        }

        public ParsedSlowLogRecordBuilder withTransactionId(long transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public ParsedSlowLogRecordBuilder withHasQcHit(boolean hasQHit) {
            this.hasQcHit = hasQHit;
            return this;
        }

        public ParsedSlowLogRecordBuilder withHasFullScan(boolean hasFullScan) {
            this.hasFullScan = hasFullScan;
            return this;
        }

        public ParsedSlowLogRecordBuilder withHasFullJoin(boolean hasFullJoin) {
            this.hasFullJoin = hasFullJoin;
            return this;
        }

        public ParsedSlowLogRecordBuilder withHasTempTables(boolean hasTempTables) {
            this.hasTempTables = hasTempTables;
            return this;
        }

        public ParsedSlowLogRecordBuilder withHasTempTablesOnDisk(boolean hasTempTablesOnDisk) {
            this.hasTempTablesOnDisk = hasTempTablesOnDisk;
            return this;
        }

        public ParsedSlowLogRecordBuilder withHasFileSort(boolean hasFileSort) {
            this.hasFileSort = hasFileSort;
            return this;
        }

        public ParsedSlowLogRecordBuilder withHasFileSortOnDisk(boolean hasFileSortOnDisk) {
            this.hasFileSortOnDisk = hasFileSortOnDisk;
            return this;
        }

        public ParsedSlowLogRecordBuilder withMergePassesCount(int mergePassesCount) {
            this.mergePassesCount = mergePassesCount;
            return this;
        }

        public ParsedSlowLogRecordBuilder withInnoDbIoReadOperationsCount(int innoDbIoReadOperationsCount) {
            this.innoDbIoReadOperationsCount = innoDbIoReadOperationsCount;
            return this;
        }

        public ParsedSlowLogRecordBuilder withInnoDbIoReadBytesCount(long innoDbIoReadBytesCount) {
            this.innoDbIoReadBytesCount = innoDbIoReadBytesCount;
            return this;
        }

        public ParsedSlowLogRecordBuilder withInnoDbReadWaitInSeconds(double innoDbReadWaitInSeconds) {
            this.innoDbReadWaitInSeconds = innoDbReadWaitInSeconds;
            return this;
        }

        public ParsedSlowLogRecordBuilder withInnoDbRecordsLockWaitInSeconds(double innoDbRecordsLockWaitInSeconds) {
            this.innoDbRecordsLockWaitInSeconds = innoDbRecordsLockWaitInSeconds;
            return this;
        }

        public ParsedSlowLogRecordBuilder withInnoQbQueueWaitInSeconds(double innoQbQueueWaitInSeconds) {
            this.innoQbQueueWaitInSeconds = innoQbQueueWaitInSeconds;
            return this;
        }

        public ParsedSlowLogRecordBuilder withInnoDbPagesCountDistinct(int innoDbPagesCountDistinct) {
            this.innoDbPagesCountDistinct = innoDbPagesCountDistinct;
            return this;
        }

        public ParsedSlowLogRawRecord build() {
            return new ParsedSlowLogRawRecord(
                    timestamp,
                    queryText,
                    userName,
                    userSecondName,
                    userHost,
                    userIp,
                    connectionId,
                    schema,
                    lastErrorNumber,
                    killedCode,
                    queryTimeInSeconds,
                    lockTimeInSeconds,
                    rowsSentCount,
                    rowsExaminedCount,
                    rowsAffectedCount,
                    bytesSentCount,
                    tempTablesCount,
                    tempTablesOnDiskCount,
                    tempTablesSizesInBytes,
                    transactionId,
                    hasQcHit,
                    hasFullScan,
                    hasFullJoin,
                    hasTempTables,
                    hasTempTablesOnDisk,
                    hasFileSort,
                    hasFileSortOnDisk,
                    mergePassesCount,
                    innoDbIoReadOperationsCount,
                    innoDbIoReadBytesCount,
                    innoDbReadWaitInSeconds,
                    innoDbRecordsLockWaitInSeconds,
                    innoQbQueueWaitInSeconds,
                    innoDbPagesCountDistinct);
        }
    }
}
