package ru.yandex.direct.mysql;

public class BinlogEvent {
    private final long timestamp;
    private final BinlogEventType type;
    private final BinlogEventData data;

    public long getTimestamp() {
        return timestamp;
    }

    public BinlogEvent(long timestamp, BinlogEventType type, BinlogEventData data) {

        this.timestamp = timestamp;
        this.type = type;
        this.data = data;
    }

    public BinlogEventType getType() {
        return type;
    }

    @SuppressWarnings("unchecked")
    public <T extends BinlogEventData> T getData() {
        return (T) data;
    }

    @Override
    public String toString() {
        return "BinlogEvent{" +
                "timestamp=" + timestamp +
                ", type=" + type +
                ", data=" + data +
                '}';
    }
}
