package ru.yandex.direct.mysql;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

import com.github.shyiko.mysql.binlog.event.TableMapEventData;

import ru.yandex.direct.mysql.schema.ColumnSchema;
import ru.yandex.direct.mysql.schema.TableSchema;

public class BinlogEventDataUtil {
    public static List<ColumnSchema> columnsFromTableMap(TableMapEventData tableMap, TableSchema tableSchema,
                                                         BitSet includedColumns, boolean returnIncluded) {
        byte[] columnTypes = tableMap.getColumnTypes();
        if (tableSchema != null && tableSchema.getColumns().size() != columnTypes.length) {
            throw new MySQLBinlogException(
                    "Table " + tableMap.getDatabase() + "." + tableMap.getTable() + " has schema with " + tableSchema
                            .getColumns().size() + " columns, but binlog data has " + columnTypes.length + " columns");
        }
        List<ColumnSchema> columns = new ArrayList<>();
        for (int i = 0; i < columnTypes.length; ++i) {
            if (includedColumns.get(i) == returnIncluded) {
                if (tableSchema != null) {
                    columns.add(tableSchema.getColumns().get(i));
                } else {
                    columns.add(new ColumnSchema("unknown_column_" + (i + 1), "any", "any", null, true));
                }
            }
        }
        return columns;
    }

    public static List<ColumnSchema> columnsFromTableMap(TableMapEventData tableMap, TableSchema tableSchema,
                                                         BitSet includedColumns) {
        return columnsFromTableMap(tableMap, tableSchema, includedColumns, true);
    }
}
