package ru.yandex.direct.mysql;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import com.github.shyiko.mysql.binlog.BinaryLogFileReader;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.deserialization.ChecksumType;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;

public class BinlogRawEventFileSource implements BinlogRawEventSource {
    private final BinaryLogFileReader binaryLogFileReader;

    public BinlogRawEventFileSource(File path, ChecksumType checksumType) throws IOException {
        EventDeserializer eventDeserializer = new EventDeserializer();
        eventDeserializer.setChecksumType(checksumType);
        binaryLogFileReader = new BinaryLogFileReader(path, eventDeserializer);
    }

    public BinlogRawEventFileSource(File path) throws IOException {
        this(path, ChecksumType.CRC32);
    }

    @Override
    public Event readEvent(long timeout, TimeUnit unit) throws IOException, TimeoutException, InterruptedException {
        return binaryLogFileReader.readEvent();
    }

    @Override
    public void close() throws IOException {
        binaryLogFileReader.close();
    }
}
