package ru.yandex.direct.mysql;

import com.github.shyiko.mysql.binlog.event.QueryEventData;
import com.github.shyiko.mysql.binlog.event.RowsQueryEventData;

import ru.yandex.direct.mysql.schema.ServerSchema;

public interface MySQLBinlogConsumer {
    void onConnect(MySQLBinlogDataStreamer streamer);

    void onDisconnect(MySQLBinlogDataStreamer streamer);

    void onDDL(String gtid, QueryEventData data, ServerSchema before, ServerSchema after);

    void onTransactionBegin(String gtid);

    void onRowsQuery(RowsQueryEventData data, long timestamp);

    void onInsertRows(MySQLSimpleData data);

    void onUpdateRows(MySQLUpdateData data);

    void onDeleteRows(MySQLSimpleData data);

    void onTransactionCommit(String gtid);
}
