package ru.yandex.direct.mysql;

import java.io.File;
import java.io.IOException;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.BinaryLogFileReader;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.deserialization.ChecksumType;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;

public class MySQLBinlogDataFileProvider implements MySQLBinlogDataProvider {
    private File file;
    private volatile boolean stopped = false;

    public MySQLBinlogDataFileProvider(File file) throws IOException {
        this.file = file;
    }

    @Override
    public void run(String gtidSet, BinaryLogClient.LifecycleListener lifecycleListener,
                    BinaryLogClient.EventListener eventListener)
            throws IOException {
        EventDeserializer eventDeserializer = new EventDeserializer();
        eventDeserializer.setChecksumType(ChecksumType.CRC32);
        try (BinaryLogFileReader reader = new BinaryLogFileReader(file, eventDeserializer)) {
            lifecycleListener.onConnect(null);
            try {
                Event event;
                while (!stopped && (event = reader.readEvent()) != null) {
                    try {
                        eventListener.onEvent(event);
                    } catch (Exception ex) {
                        // TODO: log exception like BinaryLogClient
                    }
                }
            } catch (IOException ex) {
                lifecycleListener.onCommunicationFailure(null, ex);
            } finally {
                lifecycleListener.onDisconnect(null);
            }
        }
    }

    @Override
    public void stop() {
        stopped = true;
    }
}
