package ru.yandex.direct.mysql;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

import ru.yandex.direct.mysql.schema.ColumnSchema;

public class MySQLColumnData {
    private ColumnSchema schema;
    private Serializable rawValue;

    public MySQLColumnData(ColumnSchema schema, Serializable rawValue) {
        this.schema = schema;
        this.rawValue = rawValue;
    }

    public ColumnSchema getSchema() {
        return schema;
    }

    public Serializable getRawValue() {
        return rawValue;
    }

    public String getValueAsString() {
        return rawValue == null ? null : MySQLColumnType
                .getCached(schema.getColumnType())
                .extractString(rawValue);
    }

    public Long getValueAsLong() {
        return rawValue == null ? null : MySQLColumnType
                .getCached(schema.getColumnType())
                .extractLong(rawValue);
    }

    private int rawValueHashCode() {
        if (rawValue == null) {
            return 0;
        } else if (rawValue instanceof byte[]) {
            return Arrays.hashCode((byte[]) rawValue);
        } else {
            return rawValue.hashCode();
        }
    }

    private boolean rawValueEquals(MySQLColumnData other) {
        if (rawValue instanceof byte[] && other.rawValue instanceof byte[]) {
            return Arrays.equals((byte[]) rawValue, (byte[]) other.rawValue);
        } else {
            return Objects.equals(rawValue, other.rawValue);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        MySQLColumnData other = (MySQLColumnData) o;
        return schema.equals(other.schema)
                && rawValueEquals(other);
    }

    @Override
    public int hashCode() {
        return 31 * (schema == null ? 0 : schema.hashCode())
                + rawValueHashCode();
    }

    @Override
    public String toString() {
        return "MySQLColumnData{" +
                "schema=" + schema +
                ", rawValue=" + rawValue +
                '}';
    }
}
