package ru.yandex.direct.mysql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

import com.github.shyiko.mysql.binlog.event.RowsQueryEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;

import ru.yandex.direct.mysql.schema.ColumnSchema;
import ru.yandex.direct.mysql.schema.TableSchema;

public class MySQLSimpleData {
    private long timestamp;
    private TableSchema schema;
    private TableMapEventData tableMap;
    private RowsQueryEventData rowsQuery;
    private List<Serializable[]> rows;
    private List<ColumnSchema> columns;

    public MySQLSimpleData(long timestamp, List<Serializable[]> rows, BitSet includedColumns, TableSchema schema,
                           TableMapEventData tableMap, RowsQueryEventData rowsQuery) {
        this.timestamp = timestamp;
        this.schema = schema;
        this.tableMap = tableMap;
        this.rowsQuery = rowsQuery;
        this.rows = rows;
        byte[] columnTypes = tableMap.getColumnTypes();
        if (schema != null && schema.getColumns().size() != columnTypes.length) {
            throw new MySQLBinlogException(
                    "Table " + tableMap.getDatabase() + "." + tableMap.getTable() + " has schema with " + schema
                            .getColumns().size() + " columns, but binlog data has " + columnTypes.length + " columns");
        }
        columns = new ArrayList<>();
        for (int i = 0; i < columnTypes.length; ++i) {
            if (includedColumns.get(i)) {
                columns.add(getColumn(i));
            }
        }
    }

    private ColumnSchema getColumn(int index) {
        if (schema != null) {
            return schema.getColumns().get(index);
        }
        // Table schema is unknown, generate a fake column schema
        return new ColumnSchema("unknown_column_" + (index + 1), "any", "any", null, true);
    }

    public long getTimestamp() {
        return timestamp;
    }

    public TableSchema getSchema() {
        return schema;
    }

    public TableMapEventData getTableMap() {
        return tableMap;
    }

    public String getRowsQuery() {
        return rowsQuery != null ? rowsQuery.getQuery() : "";
    }

    public MySQLSimpleRows getRows() {
        return new MySQLSimpleRows(columns, rows);
    }
}
