package ru.yandex.direct.mysql;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import java.util.stream.Stream;

import ru.yandex.direct.mysql.schema.ColumnSchema;

public class MySQLSimpleRows extends AbstractList<MySQLSimpleRow> {
    private final List<ColumnSchema> columns;
    private final List<Serializable[]> rows;
    private final List<ColumnSchema> defaultColumns;

    public MySQLSimpleRows(List<ColumnSchema> columns, List<Serializable[]> rows, List<ColumnSchema> defaultColumns) {
        this.columns = columns;
        this.rows = rows;
        this.defaultColumns = defaultColumns;
    }

    public MySQLSimpleRows(List<ColumnSchema> columns, List<Serializable[]> rows) {
        this(columns, rows, null);
    }

    @Override
    public MySQLSimpleRow get(int index) {
        return new MySQLSimpleRow(columns, rows.get(index), defaultColumns);
    }

    @Override
    public int size() {
        return rows.size();
    }

    public Stream<ColumnSchema> getColumns() {
        if (defaultColumns == null) {
            return columns.stream();
        } else {
            return Stream.concat(columns.stream(), defaultColumns.stream());
        }
    }
}
