package ru.yandex.direct.mysql;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import java.util.Map;

import ru.yandex.direct.mysql.schema.ColumnSchema;

public class MySQLUpdateRows extends AbstractList<MySQLUpdateRow> {
    private List<ColumnSchema> beforeColumns;
    private List<ColumnSchema> afterColumns;
    private List<Map.Entry<Serializable[], Serializable[]>> rows;

    public MySQLUpdateRows(List<ColumnSchema> beforeColumns, List<ColumnSchema> afterColumns, List<Map.Entry<Serializable[], Serializable[]>> rows) {
        this.beforeColumns = beforeColumns;
        this.afterColumns = afterColumns;
        this.rows = rows;
    }

    @Override
    public MySQLUpdateRow get(int index) {
        Map.Entry<Serializable[], Serializable[]> row = rows.get(index);
        return new MySQLUpdateRow(new MySQLSimpleRow(beforeColumns, row.getKey()), new MySQLSimpleRow(afterColumns, row.getValue()));
    }

    @Override
    public int size() {
        return rows.size();
    }

    public List<ColumnSchema> getBeforeColumns() {
        return beforeColumns;
    }

    public List<ColumnSchema> getAfterColumns() {
        return afterColumns;
    }
}
