package ru.yandex.direct.mysql.ytsync.export.task;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.ytwrapper.model.attributes.OptimizeForAttr;

public interface ExportConfig {
    String rootPath();

    String version();

    String getTablesPrefix();

    boolean importAllTables();

    List<String> getDbNames();

    Set<String> getExcludeTableNames();

    Set<String> getIncludeTableNames();

    String getYtProxy();

    String getYtTokenPath();

    String ytTablesMedium();

    OptimizeForAttr getOptimizeFor();

    String getBaseSchemaName();

    String getPpcDictSchemaName();

    int chunkSize();

    long chunksLimit();

    int threadsNum(List<String> dbNames);

    int flushIntervalMinutes();

    boolean profilingByTag();

    boolean dynamicStoreRead();
}
