package ru.yandex.direct.mysql.ytsync.export.util;

import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;

/**
 * Хранит набор отрезков id, которые осталось импортировать из таблицы.
 */
@YTreeObject
public class RangesStateRecord {
    public static final YTableEntryType<RangesStateRecord> YT_TYPE = YTableEntryTypes.yson(RangesStateRecord.class);
    public static final String DB_NAME_YTREE_FIELD_NAME = "db_name";
    public static final String RANGES_REMAINING_YTREE_FIELD_NAME = "ranges_remaining";

    @YTreeField(key = DB_NAME_YTREE_FIELD_NAME)
    private String dbName;

    /**
     * Сериализованный в JSON список TableIdRange.
     */
    @YTreeField(key = RANGES_REMAINING_YTREE_FIELD_NAME)
    private String rangesRemaining;

    public RangesStateRecord(String dbName, String rangesRemaining) {
        this.dbName = dbName;
        this.rangesRemaining = rangesRemaining;
    }

    public String getDbName() {
        return dbName;
    }

    public String getRangesRemaining() {
        return rangesRemaining;
    }
}
