package ru.yandex.direct.mysql.ytsync.export.util;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * POJO класс для диапазона [minId,maxId] и оценкой в count строк
 */
public class TableIdRange implements Comparable<TableIdRange> {
    @JsonProperty("min_id")
    private long minId;
    @JsonProperty("max_id")
    private long maxId;
    @JsonProperty("count")
    private long count;

    public TableIdRange() {
    }

    public TableIdRange(long minId, long maxId, long count) {
        this.minId = minId;
        this.maxId = maxId;
        this.count = count;
    }

    public long getMinId() {
        return minId;
    }

    public long getMaxId() {
        return maxId;
    }

    public long getCount() {
        return count;
    }

    @Override
    public int compareTo(@Nonnull TableIdRange o) {
        int result = Long.compare(minId, o.minId);
        if (result == 0) {
            result = Long.compare(maxId, o.maxId);
            if (result == 0) {
                result = Long.compare(count, o.count);
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return "TableIdRange([" + minId + "," + maxId + "], " + count + " rows)";
    }

    /**
     * Объединяет подряд идущие диапазоны, если сумма строк в них не превышает chunkSize
     */
    public static List<TableIdRange> compressList(List<TableIdRange> ranges, long chunkSize) {
        List<TableIdRange> result = new ArrayList<>(ranges.size());
        if (!ranges.isEmpty()) {
            TableIdRange last = ranges.get(0);
            for (int i = 1; i < ranges.size(); ++i) {
                TableIdRange current = ranges.get(i);
                if (last.getMaxId() + 1 != current.getMinId()) {
                    throw new IllegalArgumentException("Cannot compress non-contiguous ranges");
                }
                if (last.getCount() + current.getCount() <= chunkSize) {
                    // Объединяем диапазоны
                    last = new TableIdRange(last.getMinId(), current.getMaxId(), last.getCount() + current.getCount());
                } else {
                    result.add(last);
                    last = current;
                }
            }
            result.add(last);
        }
        return result;
    }
}
