package ru.yandex.direct.mysql.ytsync.export.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.mysql.ytsync.common.row.FlatRow;
import ru.yandex.direct.mysql.ytsync.export.util.valueprocessing.ExportFlatRowCreator;

/**
 * Загрузка данных из sql запроса в нужной схеме yt
 * <p>
 * Отличается от YtRawTableLoader тем, что ничего не знает про таблицы и их колонки
 * <p>
 * Если нужно добавление номера шарда, то обязательно использовать ColumnValuesShardTransformer
 * <p>
 * Мб переименовать в SingleQueryLoader
 */
public class YtSqlLoader implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(YtSqlLoader.class);

    private final PreparedStatement stmt;
    private final ResultSet rs;
    private final ResultSetMetaData metadata;

    private final String dbName;
    private final ExportFlatRowCreator exportFlatRowCreator;

    public YtSqlLoader(Connection conn, String query, String dbName, ExportFlatRowCreator exportFlatRowCreator)
            throws SQLException {
        this.exportFlatRowCreator = exportFlatRowCreator;
        this.dbName = dbName;

        stmt = conn.prepareStatement(query, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY);
        try {
            stmt.setFetchSize(Integer.MIN_VALUE);
            rs = stmt.executeQuery();
            try {
                metadata = rs.getMetaData();
            } catch (SQLException e) {
                this.rs.close();
                throw e;
            }
        } catch (SQLException e) {
            stmt.close();
            throw e;
        }
    }

    public FlatRow next() throws SQLException {
        if (!rs.next()) {
            return null;
        }
        try {
            return exportFlatRowCreator.createFrom(dbName, metadata, rs);
        } catch (Exception e) {
            logger.error("Got error", e);
            throw e;
        }
    }

    @Override
    public void close() {
        try {
            stmt.cancel();
            rs.close();
        } catch (SQLException e) {
            logger.error("Got error", e);
        } finally {
            try {
                stmt.close();
            } catch (SQLException e) {
                logger.error("Got error", e);
            }
        }
    }
}
