package ru.yandex.direct.mysql.ytsync.export.util.iterators;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

import ru.yandex.direct.mysql.ytsync.common.row.FlatRow;
import ru.yandex.direct.mysql.ytsync.export.util.YtSqlLoader;

/**
 * Превращает YtSqlLoader в итератор кошерных YTreeMapNode
 */
public class SqlLoaderToFlatRowIterator implements Iterator<FlatRow> {
    private final YtSqlLoader loader;
    private FlatRow row;
    private boolean fetched;

    public SqlLoaderToFlatRowIterator(YtSqlLoader loader) {
        this.loader = Objects.requireNonNull(loader);
    }

    private void prefetch() {
        if (!fetched) {
            try {
                row = loader.next();
            } catch (SQLException e) {
                // FIXME(snaury): придумать какое-то внятное исключение
                throw new RuntimeException(e);
            }
            fetched = true;
        }
    }

    @Override
    public boolean hasNext() {
        prefetch();
        return row != null;
    }

    @Override
    public FlatRow next() {
        prefetch();
        if (row == null) {
            throw new NoSuchElementException();
        }
        fetched = false;
        return row;
    }

    /**
     * Возвращает единый итератор на основе потока YtSqlLoader'ов
     */
    public static Iterator<FlatRow> fromStream(Iterator<YtSqlLoader> loaders) {
        return new Iterator<FlatRow>() {
            private SqlLoaderToFlatRowIterator current;

            @Override
            public boolean hasNext() {
                while (true) {
                    if (current != null && current.hasNext()) {
                        return true;
                    }
                    current = null;
                    if (!loaders.hasNext()) {
                        return false;
                    }
                    current = new SqlLoaderToFlatRowIterator(loaders.next());
                }
            }

            @Override
            public FlatRow next() {
                if (!hasNext()) {
                    throw new NoSuchElementException();
                }
                return current.next();
            }
        };
    }
}
