package ru.yandex.direct.mysql.ytsync.export.util.queue;

import java.util.function.Consumer;

/**
 * Полученное из ShardedQueue значение
 */
public class ShardedQueueValue<T> {
    private final String dbName;
    private final T value;
    private final Consumer<String> releaseConsumer;
    private boolean closed;

    public ShardedQueueValue(String dbName, T value, Consumer<String> releaseConsumer) {
        this.dbName = dbName;
        this.value = value;
        this.releaseConsumer = releaseConsumer;
    }

    /**
     * Номер шарда из которого было получено значение
     */
    public String getDbName() {
        return dbName;
    }

    /**
     * Значение полученное из очереди соответствующего шарда
     */
    public T getValue() {
        return value;
    }

    /**
     * Сигнализирует окончание обработки значения
     */
    public void release() {
        if (!closed) {
            closed = true;
            releaseConsumer.accept(dbName);
        }
    }
}
