package ru.yandex.direct.mysql.ytsync.export.util.queue;

import java.util.concurrent.atomic.AtomicLong;

import ru.yandex.direct.mysql.ytsync.export.util.IdRange;

/**
 * Не отдаёт суммарно больше, чем limit диапазонов -- для ограничения импорта по количеству считываемых чанков.
 */
public class ShardedQueueWithLimit extends ShardedQueue<IdRange> {
    private final AtomicLong allowedRanges;

    public ShardedQueueWithLimit(long limit) {
        this.allowedRanges = new AtomicLong(limit);
    }

    @Override
    public synchronized ShardedQueueValue<IdRange> poll() {
        if (allowedRanges.getAndDecrement() > 0) {
            return super.poll();
        } else {
            return null;
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return allowedRanges.get() <= 0 || super.isEmpty();
    }

    @Override
    public synchronized long getChunksCount() {
        return Math.min(super.getChunksCount(), allowedRanges.get());
    }
}
