package ru.yandex.direct.mysql.ytsync.export.util.valueprocessing;

import java.util.function.Function;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.mysql.ytsync.common.row.FlatRowFieldProcessor;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

@ParametersAreNonnullByDefault
public class ExportFieldProcessor<T> extends FlatRowFieldProcessor<T, ResultSetPair> {
    static final int NO_INDEX = -1;

    public ExportFieldProcessor(String name,
                                @Nullable Function<String, YTreeNode> defaultValueProvider,
                                @Nullable ResultSetValueExtractor<T> resultSetValueExtractor, @Nullable Function<T, ?> transformer) {
        super(name, defaultValueProvider, resultSetValueExtractor, rs -> rs.getIndex() == NO_INDEX, transformer);
    }
}
