package ru.yandex.direct.mysql.ytsync.export.util.valueprocessing;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import ru.yandex.direct.mysql.ytsync.common.row.FlatRow;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.yt.ytclient.tables.TableSchema;

import static ru.yandex.direct.mysql.ytsync.export.util.valueprocessing.ExportFieldProcessor.NO_INDEX;

public class ExportFlatRowCreator {
    private final TableSchema schema;
    private final Map<String, Map<String, List<ExportFieldProcessor<?>>>> tableFieldObj;
    private final List<ExportFieldProcessor<?>> additionalFields;

    public ExportFlatRowCreator(TableSchema schema,
                                Map<String, Map<String, List<ExportFieldProcessor<?>>>> tableFieldObj,
                                List<ExportFieldProcessor<?>> additionalFields) {
        this.schema = schema.toWrite();
        this.tableFieldObj = tableFieldObj;
        this.additionalFields = additionalFields;
    }

    public FlatRow createFrom(String dbName, ResultSetMetaData resultSetMetaData, ResultSet resultSet) throws SQLException {
        FlatRow row = new FlatRow(schema.getColumnsCount());

        int columnCount = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= columnCount; i++) {
            String tableName = resultSetMetaData.getTableName(i);
            String fieldName = resultSetMetaData.getColumnName(i);
            String columnLabel = resultSetMetaData.getColumnLabel(i);

            List<ExportFieldProcessor<?>> fields = tableFieldObj.getOrDefault(tableName, Collections.emptyMap())
                    .getOrDefault(fieldName, Collections.emptyList());
            for (ExportFieldProcessor<?> field : fields) {
                if (!field.getName().equals(columnLabel)) {
                    continue;
                }
                YTreeNode node = field.createNode(dbName, new ResultSetPair(i, resultSet));
                row.set(schema.findColumn(columnLabel), node);
            }
        }

        for (ExportFieldProcessor<?> field : additionalFields) {
            YTreeNode node = field.createNode(dbName, new ResultSetPair(NO_INDEX, resultSet));
            row.set(schema.findColumn(field.getName()), node);
        }

        return row;
    }
}
