package ru.yandex.direct.mysql.ytsync.common.compatibility;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;

import ru.yandex.direct.mysql.ytsync.common.keys.PivotKeys;
import ru.yandex.direct.mysql.ytsync.common.row.FlatRow;
import ru.yandex.direct.mysql.ytsync.common.row.FlatRowView;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.yt.ytclient.tables.TableSchema;
import ru.yandex.yt.ytclient.wire.UnversionedRowset;

/**
 * Реализация BasicYtSupport через делегацию вызовов в другой BasicYtSupport
 */
public class BasicYtSupportDelegate implements BasicYtSupport {
    private final BasicYtSupport base;

    public BasicYtSupportDelegate(BasicYtSupport base) {
        this.base = base;
    }

    protected BasicYtSupport base() {
        return base;
    }

    @Override
    public ScheduledExecutorService executor() {
        return base.executor();
    }

    @Override
    public CompletableFuture<Boolean> exists(String path) {
        return base.exists(path);
    }

    @Override
    public CompletableFuture<YTreeNode> getNode(String path) {
        return base.getNode(path);
    }

    @Override
    public CompletableFuture<YTreeNode> getNode(String path, Set<String> attributes) {
        return base.getNode(path, attributes);
    }

    @Override
    public CompletableFuture<Void> setNode(String path, YTreeNode value) {
        return base.setNode(path, value);
    }

    @Override
    public CompletableFuture<YtLock> lockNodeExclusive(String path, String title, boolean waitable) {
        return base.lockNodeExclusive(path, title, waitable);
    }

    @Override
    public CompletableFuture<Void> remove(String path) {
        return base.remove(path);
    }

    @Override
    public CompletableFuture<Void> createTable(String path, Map<String, YTreeNode> attributes) {
        return base.createTable(path, attributes);
    }

    @Override
    public CompletableFuture<Void> reshardTable(String path, PivotKeys pivotKeys) {
        return base.reshardTable(path, pivotKeys);
    }

    @Override
    public CompletableFuture<Void> mountTable(String path) {
        return base.mountTable(path);
    }

    @Override
    public CompletableFuture<Void> unfreezeTable(String path) {
        return base.unfreezeTable(path);
    }

    @Override
    public CompletableFuture<Void> unmountTable(String path) {
        return base.unmountTable(path);
    }

    @Override
    public CompletableFuture<List<FlatRow>> selectRows(String query, TableSchema resultSchema) {
        return base.selectRows(query, resultSchema);
    }

    @Override
    public CompletableFuture<UnversionedRowset> selectRows(String query) {
        return base.selectRows(query);
    }

    @Override
    public CompletableFuture<? extends BasicTransaction> nullTransaction() {
        return base.nullTransaction().thenApply(this::wrapTransaction);
    }

    @Override
    public CompletableFuture<? extends BasicTransaction> startTransaction() {
        return base.startTransaction().thenApply(this::wrapTransaction);
    }

    /**
     * Позволяет переопределить оборачивание транзакций
     */
    protected BasicTransaction wrapTransaction(BasicTransaction tx) {
        return new BasicTransactionDelegate(tx);
    }

    /**
     * Оборачивает транзакцию возвращая правильный support
     */
    protected class BasicTransactionDelegate implements BasicTransaction {
        private final BasicTransaction base;

        public BasicTransactionDelegate(BasicTransaction base) {
            this.base = base;
        }

        protected BasicTransaction base() {
            return base;
        }

        @Override
        public BasicYtSupport support() {
            return BasicYtSupportDelegate.this;
        }

        @Override
        public boolean isAtomic() {
            return base.isAtomic();
        }

        @Override
        public CompletableFuture<Void> ping() {
            return base.ping();
        }

        @Override
        public CompletableFuture<Void> abort() {
            return base.abort();
        }

        @Override
        public CompletableFuture<Void> commit() {
            return base.commit();
        }

        @Override
        public CompletableFuture<Void> insertRows(String path, TableSchema schema, List<? extends FlatRowView> rows) {
            return base.insertRows(path, schema, rows);
        }

        @Override
        public CompletableFuture<Void> updateRows(String path, TableSchema schema, List<? extends FlatRowView> rows) {
            return base.updateRows(path, schema, rows);
        }

        @Override
        public CompletableFuture<Void> deleteRows(String path, TableSchema schema, List<? extends FlatRowView> keys) {
            return base.deleteRows(path, schema, keys);
        }

        @Override
        public CompletableFuture<Void> modifyRows(String path, TableSchema schema,
                                                  List<? extends FlatRowView> insertedRows,
                                                  List<? extends FlatRowView> updatedRows, List<? extends FlatRowView> deletedKeys) {
            return base.modifyRows(path, schema, insertedRows, updatedRows, deletedKeys);
        }

        @Override
        public CompletableFuture<List<FlatRow>> lookupRows(String path, TableSchema keySchema,
                                                           List<? extends FlatRowView> keys, TableSchema resultSchema) {
            return base.lookupRows(path, keySchema, keys, resultSchema);
        }
    }
}
