package ru.yandex.direct.mysql.ytsync.common.compatibility;

import java.io.IOException;

import ru.yandex.inside.yt.kosher.impl.common.http.Compressor;
import ru.yandex.inside.yt.kosher.impl.common.http.DeflateCompressor;
import ru.yandex.inside.yt.kosher.impl.common.http.EmptyCompressor;
import ru.yandex.inside.yt.kosher.impl.common.http.LzopCompressor;

@FunctionalInterface
public interface KosherCompressorFactory {
    Compressor createCompressor();

    static KosherCompressorFactory emptyCompressor() {
        return EmptyCompressor::new;
    }

    static KosherCompressorFactory deflateCompressor(int level) {
        return () -> {
            try {
                return new DeflateCompressor(level);
            } catch (IOException e) {
                throw new IllegalStateException("Unexpected IOException", e);
            }
        };
    }

    static KosherCompressorFactory lzopCompressor() {
        return LzopCompressor::new;
    }
}
